/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.ComputedVariable;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.tileentities.instances.TileEntityDecor;
import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import minecrafttransportsimulator.items.instances.ItemDecor;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityGUIRequest;
import minecrafttransportsimulator.packets.instances.PacketEntityInteractGUI;

public class TileEntityChest
extends TileEntityDecor {
    public final EntityInventoryContainer inventory;

    public TileEntityChest(AWrapperWorld world, Point3D position, IWrapperPlayer placingPlayer, ItemDecor item, IWrapperNBT data) {
        super(world, position, placingPlayer, item, data);
        this.inventory = new EntityInventoryContainer(world, data != null ? data.getData("inventory") : null, (int)(((JSONDecor)this.definition).decor.inventoryUnits * 9.0f), ((JSONDecor)this.definition).decor.inventoryStackSize > 0 ? ((JSONDecor)this.definition).decor.inventoryStackSize : 64);
        world.addEntity(this.inventory);
    }

    @Override
    public void remove() {
        super.remove();
        this.inventory.remove();
    }

    @Override
    public void destroy(BoundingBox box) {
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            IWrapperItemStack stack = this.inventory.getStack(i);
            if (stack == null) continue;
            this.world.spawnItemStack(stack, this.position, null);
        }
        super.destroy(box);
    }

    @Override
    public boolean interact(IWrapperPlayer player) {
        player.sendPacket(new PacketEntityGUIRequest(this, player, PacketEntityGUIRequest.EntityGUIType.INVENTORY_CHEST));
        this.playersInteracting.add(player);
        InterfaceManager.packetInterface.sendToAllClients(new PacketEntityInteractGUI(this, player, true));
        return true;
    }

    @Override
    public ComputedVariable createComputedVariable(String variable, boolean createDefaultIfNotPresent) {
        switch (variable) {
            case "inventory_count": {
                return new ComputedVariable(this, variable, partialTicks -> this.inventory != null ? (double)this.inventory.getStackCount() : 0.0, false);
            }
            case "inventory_percent": {
                return new ComputedVariable(this, variable, partialTicks -> this.inventory != null ? (double)this.inventory.getStackCount() / (double)this.inventory.getSize() : 0.0, false);
            }
            case "inventory_capacity": {
                return new ComputedVariable(this, variable, partialTicks -> this.inventory != null ? (double)this.inventory.getSize() : 0.0, false);
            }
        }
        return super.createComputedVariable(variable, createDefaultIfNotPresent);
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        if (this.inventory != null) {
            data.setData("inventory", this.inventory.save(InterfaceManager.coreInterface.getNewNBTWrapper()));
        }
        return data;
    }
}

